### 29.2.1. 连接MongoDB数据库

你可以注入一个自动配置的`org.springframework.data.mongodb.MongoDbFactory`来访问Mongo数据库。默认情况下，该实例将尝试使用URL：`mongodb://localhost/test`连接一个MongoDB服务器。
```java
import org.springframework.data.mongodb.MongoDbFactory;
import com.mongodb.DB;

@Component
public class MyBean {

    private final MongoDbFactory mongo;

    @Autowired
    public MyBean(MongoDbFactory mongo) {
        this.mongo = mongo;
    }

    // ...
    public void example() {
        DB db = mongo.getDb();
        // ...
    }
}
```
你可以通过设置`spring.data.mongodb.uri`来改变该url，或指定一个host/port。比如，你可能会在你的application.properties中设置如下的属性：
```java
spring.data.mongodb.host=mongoserver
spring.data.mongodb.port=27017
```
**注**：如果没有指定`spring.data.mongodb.port`，那将使用默认的端口27017。你可以简单的从上面的示例中删除这一行。如果不使用Spring Data Mongo，你可以注入com.mongodb.Mongo beans而不是使用MongoDbFactory。

如果想全面控制MongoDB连接的建立，你也可以声明自己的MongoDbFactory或Mongo，@Beans。
